% extracts prices from the output of valueindex.m given a node in the
% trajectory set and Strikes K

function [v0]=price2(V,node,K)

[~,~,l]=size(V);
Strikes=length(K);

if length(node)==2
    
    k0=node(1); j0=node(2);
    
    for i=1:l

        if V(1,1,i)==k0 && V(1,2,i)==j0 

            v0=V(1,(2:2:2*Strikes)+2,i);

        end

    end
    
    
elseif length(node)==3

    k0=node(1); j0=node(2); n0=node(3);

    for i=1:l

        if V(1,1,i)==k0 && V(1,2,i)==j0 && V(1,3,i)==n0

            v0=V(1,(2:2:2*Strikes)+3,i);

        end

    end
    
end

end