% Takes as an input any integer node in the trajectory set i.e [k,n] or
% [k,j,n] and outputs the children integer nodes based on the model
% specified. For more model details see Trajectorial Asset Models with
% Operational Assumptions by S.Ferrando and A. Fleck.

function [N_E]=M1_DP(n,~,~)

global M_T F gamma mjmax mjmin qjmax qjmin tau

k=n(1);
j=n(2);

N_E=[];

A= (gamma <= (M_T-j) & (tau>=1)) | ( (j<tau) & (qjmin <= (M_T-j)) ) ;

B= ( (M_T-j) < qjmin ) ;

C= (~A & ~B);

    %bigger than delta
    if A || C
    
        [X,Y]=meshgrid(qjmin:qjmax, [mjmin:-F,F:mjmax]);
        N_E= [ k*ones(size(Y(:))), j*ones(size(Y(:))) ]+ [Y(:),X(:)];
    
    end
    
    %smaller than delta
    if B || C %is this right?!

        [X,Y]=meshgrid(1:M_T , [-F:-1,1:F]);
        N_E= [ k*ones(size(Y(:))), j*ones(size(Y(:))) ]+ [Y(:),X(:)];

    end
 
N_E=unique(N_E,'rows','stable');
    
% %increment to skip time with
% I=2;    
% N_E(1:I:end,:)=[];
    
end