function [As,I]=Model_2_Direct_Product(initial_node,Vup,Vdown)

global M_T F mjmax mjmin qjmax qjmin N_E_A N_E_B

%create contitional set outside grid construction for efficiancy. See section 7 in algorithm paper for more details   

%Subsampling- see note in README 
step=2; 
    
[X,Y]=meshgrid( [qjmin:step:qjmax], [mjmin,-F,F,mjmax] ); %have only extremes 
N_A=[Y(:),X(:)];
N_E_A=[];

clear X Y

[X,Y]=meshgrid([1:step:M_T] , [-F,-1,1,F]);%have only extremes
N_B=[Y(:),X(:)];
N_E_B=[];

clear X Y

F_array1=[1:F,-F:-1]; F_array2=[1:2*F,-2*F:-1];

m_array_A=N_A(:,1); q_array_A=N_A(:,2);

%computation of variation sums

K=50;

for i=1:length(m_array_A)
   
    w_array=[];
    
    if q_array_A(i)==1
        w_array=abs(m_array_A(i)); %only possibility
    else
        
        for j=1:K   
            
            p0=F_array1(ceil(length(F_array1)*rand));
            pj=F_array2(ceil(length(F_array2)*rand(1,q_array_A(i)-2)));
            
            p_array=[p0,pj];
            
            if abs(sum(p_array))>abs(m_array_A(i))
                
                p_array=p_array(cumsum(p_array)<m_array_A(i));
                p_array=[p_array,m_array_A(i)-sum(p_array)];
                
            elseif abs(m_array_A(i))>abs(sum(p_array))
                
                p_array=[p_array,m_array_A(i)-sum(p_array)];
                
            end

            w_array=[w_array;sum(abs(p_array))];
                
        end
        
    end
    
    N_E_A=[N_E_A; ones(length(w_array),1)*m_array_A(i), w_array, ones(length(w_array),1)*q_array_A(i)];
           
end

m_array_B=N_B(:,1); q_array_B=N_B(:,2);

for i=1:length(m_array_B)
   
    w_array=[];
    
    if q_array_B(i)==1
        w_array=abs(m_array_B(i)); %only possibility
    else
        
       for j=1:K
           
            p0=F_array1(ceil(length(F_array1)*rand));
            pj=F_array2(ceil(length(F_array2)*rand(1,q_array_B(i)-2)));
            
            p_array=[p0,pj];
            
            if abs(sum(p_array))>abs(m_array_B(i))
                p_array=p_array(cumsum(p_array)<m_array_B(i));
                p_array=[p_array,m_array_B(i)-sum(p_array)];
            elseif abs(m_array_B(i))>abs(sum(p_array))
                p_array=[p_array,m_array_B(i)-sum(p_array)];
            end

            w_array=[w_array;sum(abs(p_array))];
                
        end
        
        
    end
    
    N_E_B=[N_E_B; ones(length(w_array),1)*m_array_B(i), w_array, ones(length(w_array),1)*q_array_B(i)];
           
end

N_E_A=unique(N_E_A,'rows','stable');
N_E_B=unique(N_E_B,'rows','stable');

tic;
[As,I]=creatematrix(initial_node,[ceil(M_T/qjmin)*mjmax, ceil(max(Vup))+min(mjmax,-mjmin), M_T],'M2',Vup, Vdown);
toc;

end