% Takes as an input any integer node in the trajectory set i.e [k,n] or
% [k,j,n] and variation bounds Vup and Vdown. Outputs the children integer
% nodes based on the model specified. For more model details see
% Trajectorial Asset Models with Operational Assumptions by S.Ferrando and
% A. Fleck.

function [n1]=M2(n,Vup,Vdown)

global M_T gamma mjmax mjmin qjmin tau N_E_A N_E_B
k=n(1); w=n(2); j=n(3); 

A= (gamma <= (M_T-j) & (tau>=1)) | ( (j<tau) & (qjmin <= (M_T-j)) ) ;

B= ( (M_T-j) < qjmin ) ;

C= (~A & ~B);

n1=[];

%bigger than delta
if A || C
    l=length(N_E_A(:,1));
    n1=[k*ones(l,1) w*ones(l,1) j*ones(l,1)]+N_E_A;
end
    
%smaller than delta
if B || C 
    
    if ~isempty(N_E_B) %for case of delta=delta0
    
    l=length(N_E_B(:,1));
    n1=[k*ones(l,1) w*ones(l,1) j*ones(l,1)]+N_E_B;
    
    end
    
end

% if j<M_T   
%     n1(n1(:,2)>Vup(j+2) | n1(:,2)<Vdown(j+2),:)=[];
% end

for i=j+1:M_T
    indx=find(n1(:,3)==i & (n1(:,2)>Vup(i) | n1(:,2)<Vdown(i)));
    n1( indx ,:)=[];
end

n1(n1(:,3)>M_T,:)=[];

if isempty(n1) | all(n1(:,1)>=0) | all(n1(:,1)<=0)
    s=min(mjmax,-mjmin);
    n1=[n1; k+s, w+s, M_T ; k-s, w+s, M_T ]; %need to revamp like in pg 6   
end

n1=unique(n1,'rows','stable');
    
end