% Takes as an input any integer node in the trajectory set i.e [k,n] or
% [k,j,n] and outputs the children integer nodes based on the model
% specified. For more model details see Trajectorial Asset Models with
% Operational Assumptions by S.Ferrando and A. Fleck.

function [N_E]=M1_OBS(n,~,~)

global M_T gamma qjmin tau n1 n0

k=n(1);
j=n(2);

N_E=[];

A= (gamma <= (M_T-j) & (tau>=1)) | ( (j<tau) & (qjmin <= (M_T-j)) ) ;

B= ( (M_T-j) < qjmin ) ;

C= (~A & ~B);

    %bigger than delta
    if A || C

        N_E= [ k*ones(size(n1(:,1))), j*ones(size(n1(:,1))) ]+ n1;
    
    end
    
    %smaller than delta
    if B || C %is this right?!

        N_E= [ k*ones(size(n0(:,1))), j*ones(size(n0(:,1))) ]+ n0;

    end

% %increment to skip time with
% I=2;
% N_E(1:I:end,:)=[];

N_E=unique(N_E,'rows','stable');
    
end