function [As,I]=Model_2_Observable(initial_node,Vup,Vdown)

global M_T F mjmax mjmin qjmin n1 n0 N_E_A N_E_B

%create contitional set outside grid construction for efficiancy. See section 7 in algorithm paper for more details       

N_E_A=[];

N_E_B=[];

F_array1=1:F; F_array2=1:2*F;

m_array_A=n1(:,1); q_array_A=n1(:,2);

% to eliminate repeated observations%%%%%%
[q_array_A, idx]=sort(q_array_A);
m_array_A = m_array_A(idx);

keep_indx=[];

%Subsampling- see note in README

times=unique(q_array_A,'rows','stable');
for i=1:length(times)
   
    tindx=find(q_array_A==times(i));
    m_array_A(tindx)=sort(m_array_A(tindx));

    keep=[min(m_array_A(tindx));-F;F; max(m_array_A(tindx))];
    
    keep_indx=[keep_indx ; find( ismember( m_array_A, keep) & q_array_A==i)];

end

m_array_A=m_array_A(keep_indx); q_array_A=q_array_A(keep_indx);

%computation of variation sums

K=50; 

for i=1:length(m_array_A)
   
    w_array=[];
    
    if q_array_A(i)==1
        w_array=abs(m_array_A(i)); %only possibility
    else
        
        for j=1:K   
            
            p0=F_array1(ceil(length(F_array1)*rand));
            pj=F_array2(ceil(length(F_array2)*rand(1,q_array_A(i)-2)));
            
            p_array=[p0,pj];
            
            if abs(sum(p_array))>abs(m_array_A(i))
                
                p_array=p_array(cumsum(p_array)<m_array_A(i));
                p_array=[p_array,m_array_A(i)-sum(p_array)];
                
            elseif abs(m_array_A(i))>abs(sum(p_array))
                
                p_array=[p_array,m_array_A(i)-sum(p_array)];
                
            end

            w_array=[w_array;sum(abs(p_array))];
                
        end
        
    end
    
    N_E_A=[N_E_A; ones(length(w_array),1)*m_array_A(i),w_array,ones(length(w_array),1)*q_array_A(i)];
    
end

if ~isempty(n0)

m_array_B=n0(:,1); q_array_B=n0(:,2);

for i=1:length(m_array_B)
    w_array=[];
    
    if q_array_B(i)==1
        w_array=abs(m_array_B(i)); %only possibility
    else
        
       for j=1:K
           
            p0=F_array1(ceil(length(F_array1)*rand));
            pj=F_array2(ceil(length(F_array2)*rand(1,q_array_B(i)-2)));
            
            p_array=[p0,pj];
            
            if abs(sum(p_array))>abs(m_array_B(i))
                p_array=p_array(cumsum(p_array)<m_array_B(i));
                p_array=[p_array,m_array_B(i)-sum(p_array)];
            elseif abs(m_array_B(i))>abs(sum(p_array))
                p_array=[p_array,m_array_B(i)-sum(p_array)];
            end

            w_array=[w_array;sum(abs(p_array))];
                
        end
        
        
    end
    
    N_E_B=[N_E_B; ones(length(w_array),1)*m_array_B(i),w_array,ones(length(w_array),1)*q_array_B(i)];
          
end

end

N_E_A=unique(N_E_A,'rows','stable');
N_E_B=unique(N_E_B,'rows','stable');

tic;
[As,I]=creatematrix(initial_node,[ceil(M_T/qjmin)*mjmax, ceil(max(Vup))+min(mjmax,-mjmin), M_T],'M2',Vup, Vdown);
toc;

end