#!/usr/bin/python3
# -----------------------------------------------------------------
# 04 - geneticCalibration.py
#
# Authors: B.Tarraf, M.Leguebe
#
# Calibrates a set of parameters to experimental data
# using a genetic algorithm with a custom distance function
# as fitness critetion
#
# -----------------------------------------------------------------

import sys
from SALib.sample import saltelli

# Uncomment the following line and set the path 
# or use PYTHONPATH environment variable :
#sys.path.insert(0,'/path/to/pyCompMito/')
from pyCompMito import *

# Temporary files will be written here
tmpDir   = './results16h00'

# Experiment to test
manip = manips["data16h00"]

# Number of Sobol samples (should be ~100)
nSamples = 2

# The problem described with the SALib format
SALibPb  = SALibTcld7Params

# The function Y = f(P), ie the model
functional = costFunc
model      = runSingleTCLD

# Number of cpus on which evaluations of f will be performed
nCpus      = 4
# Duration in HOURS of a single evaluation of f on a single CPU
timePerRun = 0.06

# Genetic algorithm parameters
# -------------------------------
# Maximum number of iterations
maxGens     = 3
# Proportion of selected population at each generation
selectRatio = 0.5
# Mutation probability
pMutate     = 0.05
# Cross breeding probability
pCross      = 0.7

# =================================================================

mkdir_p(tmpDir)
pInit = saltelli.sample(SALibPb,nSamples,calc_second_order=False)
pOpt  = geneticCalibration(pInit,functional,(model,manip),maxGens,
                           selectRatio,pMutate,pCross)
print ("Calibrated parameters and associated cost function",pOpt)
