#!/usr/bin/env python3
# -*- coding: UTF-8 -*-

#import sys
import numpy         as np
# paralleltools.py should be in same location as this file
import parallelTools as pt
#
# IMPORTANT: here import the file/module where the function func is defined!!
# either edit the next line, or make sure that PYTHONPATH is set
# >>> on the machine that will compute the function, not the machine
#     on which you launch the whole reduction !! <<<
# sys.path.insert(0,'/path/to/the/module')
from pyCompMito import *

func   = pt.loadObject(sys.argv[1])
args   = pt.loadObject(sys.argv[2])
rank   = int(sys.argv[3])
nCpu   = int(sys.argv[4])
n      = int(sys.argv[5])
rType  = sys.argv[6]
resDir = sys.argv[7]

# Compute partition and get range to compute

starts  = pt.partition(n,nCpu)
myStart = starts[rank]
myEnd   = starts[rank+1]

# Build arguments table

argsTable = pt.buildArgTable(args,n,nCpu,False)[rank]

resTmp = func(*(argsTable[0][1:]))

if rType == 'None':
  res = [np.asarray(resTmp)]
else:
  res = np.asarray(resTmp)

for i in range(myStart+1,myEnd):

  resTmp = np.asarray(func(*(argsTable[i-myStart][1:])))

  if rType == 'None':
    res.append(resTmp)
  elif rType == 'SUM':
    res += resTmp
  elif rType == 'PROD':
    res *= resTmp
  elif rType == 'MAX':
    res  = np.maximum(res,resTmp)
  elif rType == 'MIN':
    res  = np.minimum(res,resTmp)

if rType == 'None':
  res = np.array(res)

np.save('%s/res_%d_%d.npy'%(resDir,myStart,myEnd),res)

