# ======================================================================
# mitoODEModel_.py
#   generic class for mitochondrial models described by ODEs only
# ======================================================================

import numpy as np
from ..misc import *

class mitoODEModel(object):

  def __init__(self,config):
    ''' 
        Read model parameters from configuration file.
        Define state variable size and indices.
    '''
    self.nvars = 1

  def initializeStateVar(self,solver,data=None):
    '''
        Read from config or given through variable data. 
    '''
    return np.zeros((solver.nstencil,self.nvars))

  def evolStateVar(self,t,y):
    '''
        Evolution function y'=f(y,t)
    '''
    return np.zeros(y.shape,dtype=y.dtype)

  def writeOutputHeader(self,outFile):
    '''
        Output file is already open
    '''
    outFile.write("Hello\n")

  def getOutputStateVar(self,t,y):
    ''' 
         Returns line to write in ascii output file.
    '''
    
    mystr = "%e "%t 
    for i in range(self.nvars):
      mystr = mystr + "%e "%y[i]
    return mystr + "\n"

