# -----------------------------------------------------------------
# newFluxes.py
#
# Authors: B.Tarraf, M.Leguebe
# 
# Simplified fluxes fot the TCLD model 
#
# -----------------------------------------------------------------
import numpy as np
from .commonParams import *

def sigmoid(x,vmin,vmax,k,thr):
  return vmin+(vmax-vmin)*0.5*(1+np.tanh(k*(x-thr)))

# =================================================================
# JHresp: several functions tested. Expressions were proposed
# from mono-directional fits of the original MK Flux
def jHrespFit(x,p0,p1,p2,p3,p4,p5):
  deltaEResp,deltaP = x
  return sigmoid(deltaEResp,0,sigmoid(deltaP,p0,0,p1,p2),p3,sigmoid(deltaP,p4,p5,p1,p2))

# =================================================================
# JPdh
def jPdhFit0(x,p0,p1,p2,p3):
  deltaEResp,cam = x
  return p0*(1-p1*np.exp(-p2*cam)) / (np.exp(FRT*deltaEResp-lKResp)+p3)

# =================================================================
# JHF1F0:
def jHF1F0Fit(x,p0,p1,p2,p3,p4):
  deltaGp,deltaP = x
  return sigmoid(deltaGp,p0,0,p1,p2)*sigmoid(deltaP,1,0,p3,p4)

# =================================================================
# JHAnt: not fitted, MK already at 5 parameters... for a 3 variables function!

# =================================================================
# JHUni:
def jHUniFit(x,p0,p1,p2,p3):
  caC,deltaP = x
  return np.maximum(0.,caC*(p0*deltaP+p1)+p2*deltaP+p3)


