# Common parameters for our flux calculations 
import numpy as np

R = 8.315     # unit is J mol**(-1) K**(-1)
T = 310.16    # Unit is Kelvin
F = 96.480    # Unit in mC mol**(-1)
FRT = F/(R*T) # unit is m C/J = mV**(-1)

# NAD_tot = 8 nmol/mg-protein see MK97 page C720
nadTot = 8
kResp  = 1.35e18
lKResp = np.log(kResp)
