# -----------------------------------------------------------------
# experiments.py
#
# Authors: B.Tarraf, M.Leguebe
#
# A class that describes an experiment with all information
# needed in other places of the code
#
# -----------------------------------------------------------------

class experiment :

    ''' Collection of times used to select intervals
        for linear fits involved in the cost function
        startTime, endTime : range of data
        addTimes           : times of ADP additions
        bounds             : intervals on which a steady state
                             must be fitted
        dataFile           : name of the file with resp data
        paramFile          : associated parameters file
                             for ODE solving
    '''

    def __init__ (self,sT,eT,addTimes,bounds,dataFile,paramFile):

      self.startTime = sT   ; self.endTime   = eT
      self.addTimes  = addTimes;
      self.nAdds     = len(addTimes)
      self.bounds    = bounds
      self.nStates   = len(bounds)
      self.dataFile  = dataFile
      self.paramFile = paramFile

manips = {
          'data14h16': experiment(14,20.70,[16.12,19.00],\
                       [[14,15.80],[16.20,16.90],[17.25,18.90],[19.10,20.60]],\
                       "../experimentalData/data14h16.npy",\
                       "../parameterFiles/default_data14h16.init"),\
          'data15h12': experiment(10,17.95,[13.15,17.10],\
                       [[10,12.95],[13.25,14.80],[15.46,17.00],[17.20,17.92]],\
                       "../experimentalData/data15h12.npy",\
                       "../parameterFiles/default_data15h12.init"),\
          'data15h37': experiment(10,16.50,[12.08,14.02],\
                       [[10,11.80],[12.20,12.75],[13.00,13.86],[14.12,16.40]],\
                       "../experimentalData/data15h37.npy",\
                       "../parameterFiles/default_data15h37.init"),\
          'data16h00': experiment(10,16.62,[12.15,15.35],\
                       [[10,12.05],[12.25,13.60],[14.00,15.15],[15.40,16.50]],\
                       "../experimentalData/data16h00.npy",\
                       "../parameterFiles/default_data16h00.init"),\
          'data17h03': experiment(10,18.00,[12.11,15.06],\
                       [[10,11.85],[12.22,12.65],[13.00,14.90],[15.22,18.00]],\
                       "../experimentalData/data17h03.npy",\
                       "../parameterFiles/default_data17h03.init"),\
         }

