function X = trirnd(a,c,b,n)
%% function for generating n random numbers from the triangular distribution on[a,b] with shape parameter c 
%INPUT
%a: lower bound of random variable X
%b: upper bound of random variable X
%c: shape parameter such that a < c < b
%OUTPUT
%X: random number of X
%%
X=zeros(n,1);
for i = 1:n
    z = rand;
    if sqrt(z*(b-a)*(c-a))+a<c
        X(i) = sqrt(z*(b-a)*(c-a))+a;
    else
        X(i) = b-sqrt((1-z)*(b-a)*(b-c));
    end
end 
end