function cal_dataset = read_curve(cal_curve,A,B,year_scale)
%% function for reading the calibration curve and converting it to the F14C space
%INPUT
%cal_curve: name of the calibration curve
%A: early bound of the study period
%B: late bound of the study period
%OUTPUT
%cal_dataset: array containing the calibration curve bounded on [A.B]
%% open the calibration curve data
headerlines = 11;
h = fopen([cal_curve,'.14c']);
cal_dataset = textscan(h,'%f %f %f %f %f','headerlines',headerlines,'delimiter',',');
fclose(h);
curve_cal_age = flipud(cal_dataset{1});
curve_C14_age = flipud(cal_dataset{2});
curve_C14_err = flipud(cal_dataset{3});
%% convert radiocrbon ages in the calibration curve to F_14C space
curve_F14_val = exp(curve_C14_age/-8033); %convert the radiocarbon ages to the F_14C space
curve_F14_err = curve_F14_val.*curve_C14_err/8033; %convert the error to the F_14C space
%% extract data
if strcmpi(year_scale,'BC/AD') == 1
    A = 1950 - A;
    B = 1950 - B;
end
ind = (curve_cal_age >= B & curve_cal_age <= A);
cal_dataset = [curve_cal_age(ind) curve_F14_val(ind) curve_F14_err(ind)];
end