function [] = plot_difference(diff_pdfs)
%% function for plotting the pdf and hpd regions of the difference between two modeled ages
%INPUT
%diff_pdfs: matrix containing the estimated probability, 68.2%, and 95.4% 
% highest posterior density at the points of age difference
%%
X = diff_pdfs(:,1);
Xprob = diff_pdfs(:,2);
X68p2 = diff_pdfs(:,3);
X95p4 = diff_pdfs(:,4);
ind = Xprob >0.000001;
X0 = X(ind);
Xprob = Xprob(ind);
X1 = X(X95p4>0.000001);
X2 = X(X68p2>0.000001);
P1 = X95p4(X95p4>0.000001);
P2 = X68p2(X68p2>0.000001);
fill(X0,Xprob,[0.301 0.745 0.933]);
hold on
fill([X1(1); X1; X1(end)],[0; P1; 0],[0.929 0.694 0.125]);
hold on
fill([X2(1); X2; X2(end)],[0; P2; 0],[0.635 0.078 0.184]);
grid on;
xlabel('Duration (years)');
ylabel('Probability');
legend('Posterior probability','95.4 % HPD regions','68.2 % HPD regions'); 
set(gca,'XMinorTick','on');
set(gca,'TickDir','out');
end