function [] = plot_ages(pdfs,CAGES,year_scale)
%% function for plotting the results of model parameters
%INPUT
%pdfs: estimated pdf of parameters
%CAGES: structure wrapping up ALPHA, BETA, and THETA
%year_scale: scale of year (BC/AD or BP)
%%
cal_age = pdfs(:,1); 
prob = pdfs(:,2:end);
[M,N] = size(prob);
maxprob = max(max(prob))*N/(N-1);
for i = 1:N
    prob(:,i) = prob(:,i) + maxprob*(i-1);  % blow up and shift
    ind1 = (prob(:,i) > maxprob*(i-1)+0.000001);
    if strcmpi(year_scale,'BC/AD') == 1 
        early = min(cal_age(ind1));
        late = max(cal_age(ind1)); 
        ind2 = (cal_age >= early) & (cal_age <= late);
    elseif strcmpi(year_scale,'BP') == 1
        early = max(cal_age(ind1));
        late = min(cal_age(ind1)); 
        ind2 = (cal_age <= early) & (cal_age >= late);
    end        
    calage = cal_age(ind2);
    CAL_AGE = [calage(1); calage; calage(end); calage(1)];
    PROB = [maxprob*(i-1); prob(ind2,i); maxprob*(i-1); maxprob*(i-1)];
    fill(CAL_AGE,PROB,[0.301 0.745 0.933]);  % plot pdfs
    hold on
    p95_4 = CAGES(i).P95_4_regions;    % plot the 95.4% pdf
    K = size(p95_4,1);
    for j = 1:K
        id = cal_age >= p95_4(j,2) & cal_age <= p95_4(j,1);
        age = cal_age(id);
        AGE = [age(1); age; age(end); age(1)];
        pdf = prob(id,i);
        PDF = [maxprob*(i-1); pdf; maxprob*(i-1); maxprob*(i-1)];
        fill(AGE,PDF,[0.929 0.694 0.125]);
    end
    hold on
    p68_2 = CAGES(i).P68_2_regions;    % plot the 68.2% pdf 
    L = size(p68_2,1);
    for k = 1:L
        id = cal_age >= p68_2(k,2) & cal_age <= p68_2(k,1);
        age = cal_age(id);
        AGE = [age(1); age; age(end); age(1)];
        pdf = prob(id,i);
        PDF = [maxprob*(i-1); pdf; maxprob*(i-1); maxprob*(i-1)];
        fill(AGE,PDF,[0.635 0.078 0.184]); 
    end
end
xlim([min(cal_age) max(cal_age)]);
set(gca, 'TickDir', 'out');
ylim([0 N*maxprob]);
set(gca,'yticklabel',[]);
set(gca,'ytick',[]);
if strcmpi(year_scale,'BP') == 1 
   set(gca,'XDir','reverse');
   xlabel('Calendar age (BP)');
elseif strcmpi(year_scale,'BC/AD') == 1 
   xlabel('Calendar age (BC/AD)');  
end
set(gca,'XMinorTick','on');
legend('Posterior probability','95.4 % HPD regions','68.2 % HPD regions','location', 'southeast'); 
grid on;
% plot sampleID 
for i = 1:N
    if strcmpi(year_scale,'BP') == 1 
       text(max(cal_age)-25,maxprob*0.8+maxprob*(i-1),CAGES(i).SampleID); 
    elseif strcmpi(year_scale,'BC/AD') == 1 
       text(min(cal_age)+25,maxprob*0.8+maxprob*(i-1),CAGES(i).SampleID); 
    end
end
end