function p = likelihood(P,theta,A,B,year_scale,cal_dataset)
%% function for calculating the likelihood of radiocabon ages given calendar ages in F14C space
%INPUT
%P: structure containing the F14C values and erros of radiocarbon ages in the phases
%theta: structure containing the calendar ages of the phases
%A: early boundary of the age sequence
%B: late boundary of the age sequence
%year_scale: scale of year ("BC/AD" or "BP")
%cal_dataset: extracted calibration curve in the F14C space
%OUTPUT
%p: likelihood value in log scale
%% find the radiocaron age of theta from the calibration curve and convert it to F14C
M = length(P); % number of phases
N = zeros(1,M);
F = zeros(1,M);
for i = 1:M
    N(i) = length(P(i).age); 
end 
F_hat = struct('C14',[],'err',[]);
for i = 1:M
    if strcmpi(year_scale,'BC/AD') == 1
        if any(theta(i).age < A) || any(theta(i).age > B) 
            F(i) = log(0);
        else
            [F_hat(i).C14, F_hat(i).err] = calendar2f(theta(i).age,year_scale,cal_dataset);
            a = (P(i).f14C - F_hat(i).C14).^2;
            b = 2*(P(i).ferr.^2 + F_hat(i).err.^2);
            c = gamma(N(i)/2);
            F(i) = log(c)-(N(i)/2)*log(sum(a./b));
            %c = sqrt(2*pi*(P(i).ferr.^2 + F_hat(i).err.^2));
            %F(i) = sum(-log(c))+sum(-a./b);
        end   
    elseif strcmpi(year_scale,'BP') == 1
        if any(theta(i).age > A) || any(theta(i).age < B) 
            F(i) = log(0);
        else
            [F_hat(i).C14, F_hat(i).err] = calendar2f(theta(i).age,year_scale,cal_dataset);
            a = (P(i).f14C - F_hat(i).C14).^2;
            b = 2*(P(i).ferr.^2 + F_hat(i).err.^2);
            c = gamma(N(i)/2);
            F(i) = log(c)-(N(i)/2)*log(sum(a./b));
            %c = sqrt(2*pi*(P(i).ferr.^2 + F_hat(i).err.^2));
            %F(i) = sum(-log(c))+sum(-a./b);
        end
    end
end
p = sum(F);
return;
%%
function [F14_val, F14_err] = calendar2f(cal_age,year_scale,cal_dataset)
%% function for mapping a calendar age to radiocarbon age and converting it to F14C
%INPUT
%cal_age: calendar age
%cal_dataset: extracted calibration curve 
%OUTPUT
%F14_val: F14C value in the calibration curve
%F14_err: F14C error in the calibration curve  
%% convert to BP scale if needed
if strcmpi(year_scale,'BC/AD') == 1
   cal_age = 1950 - cal_age; 
end
%% find the corresponding F_14C value in the calibration curve
F14_val = interp1(cal_dataset(:,1), cal_dataset(:,2), cal_age);
F14_err = interp1(cal_dataset(:,1), cal_dataset(:,3), cal_age);
return;