function p = boundary_prior(alpha,beta,A,B,phase_relationship,year_scale)
%% function for calculating the prior probability of the phase boundaries in log scale
%INPUT
%alpha: vector containing the calendar ages of early bundaries of the phases
%beta: vector containing the calendar ages of late bundaries of the phases
%A: early boundary of the age sequence
%B: late boundary of the age sequence
%phase_relationship: relationship of two phases (overlapping, contiguous, or disjoint)
%year_scale: scale of age (BC/AD or BP)
%OUTPUT
%p: prabability in log scale
%%
M = length(alpha); %number of phases
F = zeros(1,M);
I = zeros(1,M);
%%
for i = 1:M
    if i == 1 % the first phase
        if strcmpi(year_scale,'BC/AD') == 1
            if A < alpha(i) && alpha(i) < B && A < beta(i) && beta(i) < B 
                F(i) = power(B-A,-2);
            else
                F(i) = 0;
            end
            if alpha(i) < beta(i)
                I(i) = 1;
            else
                I(i) = 0;
            end    
        elseif strcmpi(year_scale,'BP') == 1
            if A > alpha(i) && alpha(i) > B && A > beta(i) && beta(i) > B
                F(i) = power(A-B,-2);
            else
                F(i) = 0;
            end 
            if alpha(i) > beta(i)
                I(i) = 1;
            else
                I(i) = 0;
            end    
        end    
    elseif i > 1  % other phases
        if strcmpi(year_scale,'BC/AD') == 1
            if A < alpha(i) && alpha(i) < B && A < beta(i) && beta(i) < B
                F(i) = power(B-A,-2);
            else
                F(i) = 0;
            end
            if strcmpi(phase_relationship{i-1},'overlapping') == 1
                if alpha(i-1) < alpha(i) && alpha(i) < beta(i-1) && beta(i-1) < beta(i)
                    I(i) = 1;
                else
                    I(i) = 0;
                end            
            elseif strcmpi(phase_relationship{i-1},'contiguous') == 1
                if alpha(i-1) < beta(i-1) && beta(i-1) == alpha(i) && alpha(i) < beta(i)
                    I(i) = 1;
                else
                    I(i) = 0;
                end            
            elseif strcmpi(phase_relationship{i-1},'disjoint') == 1
                if alpha(i-1) < beta(i-1) && beta(i-1) < alpha(i) && alpha(i) < beta(i)
                    I(i) = 1;
                else
                    I(i) = 0;
                end
            end
        elseif strcmpi(year_scale,'BP') == 1
            if A > alpha(i) && alpha(i) > B && A > beta(i) && beta(i) > B
                F(i) = power(A-B,-2);
            else
                F(i) = 0;
            end
            if strcmpi(phase_relationship{i-1},'overlapping') == 1
                if alpha(i-1) > alpha(i) && alpha(i) > beta(i-1) && beta(i-1) > beta(i)
                    I(i) = 1;
                else
                    I(i) = 0;
                end            
            elseif strcmpi(phase_relationship{i-1},'contiguous') == 1
                if alpha(i-1) > beta(i-1) && beta(i-1) == alpha(i) && alpha(i) > beta(i)
                    I(i) = 1;
                else
                    I(i) = 0;
                end            
            elseif strcmpi(phase_relationship{i-1},'disjoint') == 1
                if alpha(i-1) > beta(i-1) && beta(i-1) > alpha(i) && alpha(i) > beta(i)
                    I(i) = 1;
                else
                    I(i) = 0;
                end
            end
        end            
    end
end 
p = sum(log(F) + log(I));    
end